unit Unit1;

interface

{==============================================================================}
{ This demo shows how to scroll to specified position of document using        }
{ special invisible labels - "checkpoints"                                     }
{ Key methods and properties:                                                  }
{ - AddNamedCheckpoint;                                                        }
{ - GetCheckpointByNo, FindCheckpointByName;                                   }
{ - GetCheckpointY, GetCheckpointYEx;                                          }
{ - ScrollTo                                                                   }
{ - Options (rvoShowCheckpoints)                                               }
{==============================================================================}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, RVStyle, RVScroll, RichView, SclRView;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    CheckBox1: TCheckBox;
    Button4: TButton;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var i, j: Integer;
begin
  srv.SetMargin(5, 5, 5, 5);

  for i := 1 to 3 do begin
    srv.RichViewEdit.AddNamedCheckpoint('C'+IntToStr(i));
    srv.RichViewEdit.AddFmt('Chapter %d', [i], 1,1);
    for j := 0 to 30 do
      srv.RichViewEdit.AddNL('Bla - bla - bla - bla - bla - bla - bla - bla'+
                      '- bla - bla - bla - bla - bla - bla - bla - bla',0,0);
  end;
  srv.RichViewEdit.AddNamedCheckpoint('END');
  srv.RichViewEdit.Format;
  {
    Comments:

    Checkpoints are not items. They are special additional information,
    associated with any item.
    (in older, freeware versions, checkpoints were items)
    But checkpoint can be added like any other item using Add*** methods:
    AddNamedCheckpoint, AddCheckpoint, AddNamedCheckpointEx, and some other.

    AddNamedCheckpoint('') == AddCheckpoint

    Checkpoint added with any of these methods will be associated with next
    added item (if no items added after it, checkpoints becomes special
    end-of-text checkpoint which is not associated with any item)

    Do not try to add checkpoints one after another without items between them
    (it's impossible, and causes the exception)
  }
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  // toggles checkpoints visibility
  if Checkbox1.Checked then
    srv.RichViewEdit.Options := srv.RichViewEdit.Options+[rvoShowCheckpoints]
  else
    srv.RichViewEdit.Options := srv.RichViewEdit.Options-[rvoShowCheckpoints];
  srv.RichViewEdit.Invalidate;
end;

procedure TForm1.Button1Click(Sender: TObject);
var CheckpointData: TCheckpointData;
    ItemNo: Integer;
begin
  // GetCheckpointByNo(checkpoint index) - returns value of type TCheckpointData,
  // identifying checkpoint
  CheckpointData := srv.RichViewEdit.GetCheckpointByNo(0);
  // GetCheckpointYEx returns ItemNo element of checkpoint
  ItemNo := srv.RichViewEdit.GetCheckpointItemNo(CheckpointData);
  // ScrollTo - scrolls to specified ItemNo element
  srv.ScrollToItem(srv.RichViewEdit.RVData, ItemNo);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  // The same actions, more compact
  with srv.RichViewEdit do
    srv.ScrollToItem(RVData, GetCheckpointItemNo(GetCheckpointByNo(1)));
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  // Even more compact
  with srv.RichViewEdit do
    srv.ScrollToItem(RVData, GetCheckpointItemNo(GetCheckpointByNo(2)));
end;

procedure TForm1.Button4Click(Sender: TObject);
var CheckpointData: TCheckpointData;
    Y : Integer;
begin
  // We can use checkpoint name to find it
  CheckpointData := srv.RichViewEdit.FindCheckpointByName('END');
  Y := srv.RichViewEdit.GetCheckpointYEx(CheckpointData);
  Y := srv.convertRVtoSRV(Point(0, Y)).Y;
  srv.VScrollPos := (Y + Round(srv.OffsetDocY)) div srv.RichViewEdit.VSmallStep;
end;

end.
